#include "pch.h"
#include "FTNStruc.hpp"

int ParseFTNAddress(const char *s, SFTNAddress &Address) {
    // parse Zone:Net/Node
    //       Zone:Net/Node.Point
    //       Zone:Net/Node.Point@Domain
    int i; // Not more then 5 symbols on number
    #ifdef SIGNED_ADDR
    int sign;
    #endif

    while (*s == ' ')
        s++;
    
    // parse zone

    #ifdef SIGNED_ADDR
    if (*s == '-') {
        sign = -1;
        s++;
    }
    else
        sign = 1;
    #endif

    Address.Zone = 0;

    i = 0;
    while (i < 5 && *s >= '0' && *s <= '9') {
        Address.Zone *= 10;
        Address.Zone += (*s - '0');
        s++;
        i++;
    }
    if (i == 0 || *s != ':')
        return (0);
    
    #ifdef SIGNED_ADDR
    Address.Zone *= sign;
    #endif
    
    s++;

    // parse net
    
    #ifdef SIGNED_ADDR
    if (*s == '-') {
        sign = -1;
        s++;
    }
    else
        sign = 1;
    #endif

    Address.Net = 0;

    i = 0;
    while (i < 5 && *s >= '0' && *s <= '9') {
        Address.Net *= 10;
        Address.Net += (*s - '0');
        s++;
        i++;
    }
    if (i == 0 || *s != '/')
        return (0);
    
    #ifdef SIGNED_ADDR
    Address.Net *= sign;
    #endif
    
    s++;
    
    // parse node

    #ifdef SIGNED_ADDR
    if (*s == '-') {
        sign = -1;
        s++;
    }
    else
        sign = 1;
    #endif

    Address.Node = 0;

    i = 0;
    while (i < 5 && *s >= '0' && *s <= '9') {
        Address.Node *= 10;
        Address.Node += (*s - '0');
        s++;
        i++;
    }
    if (i == 0)
        return (0);
    
    #ifdef SIGNED_ADDR
    Address.Node *= sign;
    #endif

    Address.Point = 0;

    if (*s == '.') {  // parse point
        s++;
        #ifdef SIGNED_ADDR
        if (*s == '-') {
            sign = -1;
            s++;
        }
        else
            sign = 1;
        #endif
        i = 0;
        while (i < 5 && *s >= '0' && *s <= '9') {
            Address.Point *= 10;
            Address.Point += (*s - '0');
            s++;
            i++;
        }
        if (i == 0)
            return (0);
        #ifdef SIGNED_ADDR
        Address.Point *= sign;
        #endif
    }

    Address.Domain[0] = '\0';
    if (*s == '@') { // parse domain
        s++;
        i = 0;
        while (i < (MAX_DOMAIN_SIZE-1) && *s != ' ' && *s != '\0') {
            Address.Domain[i] = *s;
            s++;
            i++;
        }
        if (i == 0 || (*s != ' ' && *s != '\0'))
            return (0);
        Address.Domain[i] = '\0';
        #ifdef SUBSTITUTE_DOMAIN
        if (stricmp(Address.Domain, "Fidonet.org") == 0)
            strcpy( Address.Domain, "Fidonet" );
        #endif
    }

    while (*s == ' ')
        s++;

    return (*s == '\0');
}

int AddrCmp(const SFTNAddress &Addr1, const SFTNAddress &Addr2 ) {
    if (Addr1.Zone == Addr2.Zone) {
        if (Addr1.Net == Addr2.Net) {
            if (Addr1.Node == Addr2.Node) {
                if (Addr1.Point == Addr2.Point) {
                    return (lstrcmpi( Addr1.Domain, Addr2.Domain ));
                }
                else
                    return (Addr1.Point > Addr2.Point ? 1 : -1);
            }
            else
                return (Addr1.Node > Addr2.Node ? 1 : -1);
        }
        else
            return (Addr1.Net > Addr2.Net ? 1 : -1);
    }
    else
        return (Addr1.Zone > Addr2.Zone ? 1 : -1);
}


tstring	SFTNAddress::toString() const {
	TCHAR	buffer[256];

	ToString( buffer );

	return tstring(buffer);
}


void SFTNAddress::ToString(LPTSTR szBuf) const {
	_stprintf( szBuf, _T("%hu:%hu/%hu"), Zone, Net, Node );
	if (Point != 0)
		_stprintf( szBuf+lstrlen(szBuf), _T(".%hu"), Point );
	if (*Domain != _T('\0'))
		_stprintf( szBuf+lstrlen(szBuf), _T("@%s"), Domain );
}

void SFTNAddress::ToStringWithoutDomain(LPTSTR szBuf) const {
	_stprintf( szBuf, _T("%hu:%hu/%hu"), Zone, Net, Node );
	if (Point != 0)
		_stprintf( szBuf+lstrlen(szBuf), _T(".%hu"), Point );
}

SFTNAddress& SFTNAddress::operator =(const SFTNAddress& addr) {
	Zone  = addr.Zone;
	Net   = addr.Net;
	Node  = addr.Node;
	Point = addr.Point;
	lstrcpy( Domain, addr.Domain );
	return (*this);
}


bool SFTNAddress::operator ==(const SFTNAddress& addr) {
	return (AddrCmp( *this, addr ) == 0);
}


tstring SFTNAddress::toShortestString(const SFTNAddress& baseAddr) const {
	tstring	strAddr;
	
	if (lstrcmpi( baseAddr.Domain, Domain ) != 0) {
		strAddr = toString();
	}
	else {
		TCHAR	buffer[256];

		if (Zone == baseAddr.Zone) {
			if (Net == baseAddr.Net) {
				_stprintf( buffer, TEXT("%ld"), Node );
			}
			else {
				_stprintf( buffer, TEXT("%ld/%ld"), Net, Node );
			}
		}
		else {
			_stprintf( buffer, TEXT("%ld:%ld/%ld"), Zone, Net, Node );
		}
		if (Point != 0) {
			_stprintf( buffer + lstrlen(buffer), TEXT(".%ld"), Point );
		}
		strAddr = buffer;
	}

	return strAddr;
}
